"""Normalize VM models

Revision ID: aa9810be100c
Revises: bbedeabf94c7
Create Date: 2019-11-20 12:22:11.823446+00:00

"""
import json

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'aa9810be100c'
down_revision = 'bbedeabf94c7'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('vm_vm', schema=None) as batch_op:
        batch_op.add_column(sa.Column('cores', sa.INTEGER(), nullable=True))
        batch_op.add_column(sa.Column('threads', sa.INTEGER(), nullable=True))
        batch_op.add_column(sa.Column('shutdown_timeout', sa.INTEGER(), nullable=True))

    op.execute("UPDATE vm_vm SET cores = 1, threads = 1, shutdown_timeout = 90")

    with op.batch_alter_table('vm_vm', schema=None) as batch_op:
        batch_op.alter_column('cores',
               existing_type=sa.INTEGER(),
               nullable=False)
        batch_op.alter_column('threads',
               existing_type=sa.INTEGER(),
               nullable=False)
        batch_op.alter_column('shutdown_timeout',
               existing_type=sa.INTEGER(),
               nullable=False)

    conn = op.get_bind()

    # ensure vnc port

    all_ports = [6000, 6100]
    vnc_devices = [dict(row) for row in conn.execute("SELECT * FROM vm_device WHERE dtype = 'VNC'").fetchall()]

    for vnc_device in vnc_devices:
        vnc_device['attributes'] = json.loads(vnc_device['attributes'])

        if vnc_device['attributes'].get('vnc_port'):
            try:
                port = int(vnc_device['attributes']['vnc_port'])
            except ValueError:
                vnc_device['attributes']['vnc_port'] = None
            else:
                if port in all_ports or port < 5900 or port > 65535:
                    vnc_device['attributes']['vnc_port'] = None
                else:
                    vnc_device['attributes']['vnc_port'] = port
                    all_ports.append(port)

    for vnc_device in vnc_devices:
        if not vnc_device['attributes'].get('vnc_port'):
            port = next((i for i in range(5900, 65535) if i not in all_ports))
            all_ports.append(port)
            vnc_device['attributes']['vnc_port'] = port

        if not vnc_device['attributes'].get('vnc_bind'):
            # This is to ensure old users have this as a default value
            vnc_device['attributes']['vnc_bind'] = '0.0.0.0'

        conn.execute("UPDATE vm_device SET attributes = ? WHERE id = ?", (
            json.dumps(vnc_device['attributes']), vnc_device['id']
        ))

    # add physical sector size support

    for device in conn.execute("SELECT * FROM vm_device WHERE dtype IN ('DISK', 'RAW')").fetchall():
        attributes = json.loads(device['attributes'])

        try:
            sector_size = int(attributes.pop('sectorsize', None))
            if sector_size not in [512, 4096]:
                raise ValueError('Invalid sector size')
        except (ValueError, TypeError):
            sector_size = None

        attributes.update({
            'logical_sectorsize': sector_size,
            'physical_sectorsize': None,
        })

        conn.execute("UPDATE vm_device SET attributes = ? WHERE id = ?", (json.dumps(attributes), device['id']))

    # normalize_mac_address

    for device in conn.execute("SELECT * FROM vm_device WHERE dtype = 'NIC'").fetchall():
        attributes = json.loads(device['attributes'])

        if not attributes.get('mac') or attributes['mac'] == '00:a0:98:FF:FF:FF':
            attributes['mac'] = None
            conn.execute("UPDATE vm_device SET attributes = ? WHERE id = ?", (json.dumps(attributes), device['id']))

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('vm_vm', schema=None) as batch_op:
        batch_op.drop_column('cores')
        batch_op.drop_column('threads')
        batch_op.drop_column('shutdown_timeout')

    # ### end Alembic commands ###
