"""Pool ON DELETE CASCADE

Revision ID: 6d65fd64e91c
Revises: ed69a9a6fab1
Create Date: 2019-10-25 12:36:15.863824+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '6d65fd64e91c'
down_revision = 'ed69a9a6fab1'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('storage_encrypteddisk', schema=None) as batch_op:
        batch_op.drop_constraint('fk_storage_encrypteddisk_encrypted_volume_id_storage_volume', type_='foreignkey')
        batch_op.create_foreign_key(batch_op.f('fk_storage_encrypteddisk_encrypted_volume_id_storage_volume'), 'storage_volume', ['encrypted_volume_id'], ['id'], ondelete='CASCADE')

    with op.batch_alter_table('storage_scrub', schema=None) as batch_op:
        batch_op.drop_constraint('fk_storage_scrub_scrub_volume_id_storage_volume', type_='foreignkey')
        batch_op.create_foreign_key(batch_op.f('fk_storage_scrub_scrub_volume_id_storage_volume'), 'storage_volume', ['scrub_volume_id'], ['id'], ondelete='CASCADE')

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('storage_scrub', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_storage_scrub_scrub_volume_id_storage_volume'), type_='foreignkey')
        batch_op.create_foreign_key('fk_storage_scrub_scrub_volume_id_storage_volume', 'storage_volume', ['scrub_volume_id'], ['id'])

    with op.batch_alter_table('storage_encrypteddisk', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_storage_encrypteddisk_encrypted_volume_id_storage_volume'), type_='foreignkey')
        batch_op.create_foreign_key('fk_storage_encrypteddisk_encrypted_volume_id_storage_volume', 'storage_volume', ['encrypted_volume_id'], ['id'])

    # ### end Alembic commands ###
