# -*- coding: utf-8 -*-
# Generated by Django 1.10.3 on 2017-05-04 19:05
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('vm', '0001_initial'),
    ]

    operations = [
        migrations.AlterField(
            model_name='vm',
            name='bootloader',
            field=models.CharField(choices=[('UEFI', 'UEFI'), ('UEFI_CSM', 'UEFI-CSM')], default='UEFI', help_text='System boot method and architecture.', max_length=50, verbose_name='Boot Method'),
        ),
        migrations.AlterField(
            model_name='vm',
            name='description',
            field=models.CharField(blank=True, help_text='A short description of the virtual machine.', max_length=250, verbose_name='Description'),
        ),
        migrations.AlterField(
            model_name='vm',
            name='memory',
            field=models.IntegerField(help_text='Megabytes of RAM for the virtual machine.This memory will be allocated when the VM is running and not available to the host system or other VMs.', verbose_name='Memory Size (MiB)'),
        ),
        migrations.AlterField(
            model_name='vm',
            name='name',
            field=models.CharField(help_text='Name of the virtual machine.', max_length=150, verbose_name='Name'),
        ),
        migrations.AlterField(
            model_name='vm',
            name='vcpus',
            field=models.IntegerField(default=1, help_text='Number of virtual CPUs allocated to the VM.', validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(16)], verbose_name='Virtual CPUs'),
        ),
    ]
