# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2018-07-16 19:03
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import freenasUI.freeadmin.models.fields


class Migration(migrations.Migration):

    dependencies = [
        ('system', '0032_remove_protocol_field'),
    ]

    operations = [
        migrations.CreateModel(
            name='ACMERegistration',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uri', models.URLField(verbose_name='URI')),
                ('directory', models.URLField(unique=True, verbose_name='Directory URI')),
                ('tos', models.URLField(verbose_name='Terms of Service')),
                ('new_account_uri', models.URLField(verbose_name='New Account Uri')),
                ('new_nonce_uri', models.URLField(verbose_name='New Nonce Uri')),
                ('new_order_uri', models.URLField(verbose_name='New Order Uri')),
                ('revoke_cert_uri', models.URLField(verbose_name='Revoke Certificate Uri')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ACMERegistrationBody',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('contact', models.EmailField(max_length=254, verbose_name='Contact Email')),
                ('status', models.CharField(max_length=10, verbose_name='Status')),
                ('key', models.TextField(verbose_name='JWKRSAKey')),
                ('acme', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='system.ACMERegistration')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ACMEDNSAuthenticator',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('authenticator', models.CharField(max_length=64, verbose_name='Authenticator')),
                ('name', models.CharField(max_length=64, unique=True, verbose_name='Name')),
                ('attributes', freenasUI.freeadmin.models.fields.EncryptedDictField()),
            ],
            options={
                'verbose_name': 'DNS Authenticator',
            },
        ),
        migrations.AddField(
            model_name='certificate',
            name='cert_acme_uri',
            field=models.URLField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='certificate',
            name='cert_domains_authenticators',
            field=freenasUI.freeadmin.models.fields.EncryptedDictField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='certificate',
            name='cert_renew_days',
            field=models.IntegerField(
                default=10, help_text='Number of days to renew certificate before expiring',
                verbose_name='Renew certificate day',
                blank=True, null=True
            ),
        ),
        migrations.AddField(
            model_name='certificate',
            name='cert_acme',
            field=models.ForeignKey(
                blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='system.ACMERegistration'
            ),
        ),
    ]
