# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2017-12-04 16:18
from __future__ import unicode_literals

from django.db import migrations, models
import freenasUI.freeadmin.models.fields


class Migration(migrations.Migration):

    dependencies = [
        ('system', '0012_add_filesystem_model'),
    ]

    operations = [
        migrations.CreateModel(
            name='AlertService',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(default='', help_text='Name to identify this alert service', max_length=120, verbose_name='Name')),
                ('type', models.CharField(choices=[('AWSSNS', 'AWS-SNS'), ('HipChat', 'HipChat'), ('InfluxDB', 'InfluxDB'), ('Mattermost', 'Mattermost'), ('OpsGenie', 'OpsGenie'), ('PagerDuty', 'PagerDuty'), ('Slack', 'Slack'), ('VictorOps', 'VictorOps')], default='AWS-SNS', max_length=20, verbose_name='Service Name')),
                ('attributes', freenasUI.freeadmin.models.fields.DictField(editable=False, verbose_name='Attributes')),
                ('enabled', models.BooleanField(default=True, verbose_name='Enabled')),
                ('settings', freenasUI.freeadmin.models.fields.DictField(editable=False, verbose_name='Settings')),
            ],
            options={
                'verbose_name': 'Alert Service',
                'verbose_name_plural': 'Alert Services',
                'ordering': ['type'],
            },
        ),
        migrations.RunSQL("""
            INSERT INTO system_alertservice (id, type, name, attributes, enabled, settings)
            SELECT id, consulalert_type, consulalert_type, attributes, enabled, '{}' FROM system_consulalerts
        """),
        migrations.DeleteModel(
            name='ConsulAlerts',
        ),
        migrations.RunSQL("""
            INSERT INTO system_alertservice (type, name, attributes, enabled, settings)
            VALUES ('SNMPTrap', 'SNMP Trap', '{}', 1, '{}')
        """),
        migrations.RunSQL("""
            INSERT INTO system_alertservice (type, name, attributes, enabled, settings)
            VALUES ('Mail', 'E-Mail', '{"email": ""}', 1, '{}')
        """),
    ]
