# -*- coding: utf-8 -*-
# Generated by Django 1.10.7 on 2017-07-26 13:28
from __future__ import unicode_literals

import datetime
from django.db import migrations, models


def create_resilver(apps, schema_editor):
    """
    Create an instance of the model just added
    """
    Resilver = apps.get_model('storage', 'Resilver')
    Resilver.objects.create()


class Migration(migrations.Migration):

    dependencies = [
        ('storage', '0004_disk_disk_enclosure_slot'),
    ]

    operations = [
        migrations.CreateModel(
            name='Resilver',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('enabled', models.BooleanField(default=False, verbose_name='Enabled')),
                ('begin', models.TimeField(default=datetime.time(18, 0), verbose_name='Begin higher priority resilvering at this time')),
                ('end', models.TimeField(default=datetime.time(9, 0), verbose_name='End higher priority resilvering at this time')),
                ('weekday', models.CharField(blank=True, default='1,2,3,4,5,6,7', max_length=120, verbose_name='Weekday')),
            ],
            options={
                'verbose_name': 'Resilver Priority',
            },
        ),
        migrations.RunPython(create_resilver),
    ]
