# -*- coding: utf-8 -*-
# Generated by Django 1.10.3 on 2016-12-27 21:42


from django.db import migrations, models
import django.db.models.deletion
import freenasUI.freeadmin.models.fields
from freenasUI import choices


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('storage', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='AFP_Share',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('afp_path', freenasUI.freeadmin.models.fields.PathField(max_length=255, verbose_name='Path')),
                ('afp_name', models.CharField(help_text="The volume name is the name that appears in the Chooser of the 'connect to server' dialog on Macintoshes to represent the appropriate share. If volumename is unspecified, the last component of pathname is used. No two volumes may have the same name. The volume name cannot contain the ':' character. The volume name is mangled if it is very long. Mac codepage volume name is limited to 27 characters. UTF8-MAC volume name is limited to 'Volume Name Length' parameter in Services:Apple Share", max_length=120, verbose_name='Name')),
                ('afp_comment', models.CharField(blank=True, max_length=120, verbose_name='Share Comment')),
                ('afp_allow', models.CharField(blank=True, help_text='This option allows the users and groups that access a share to be specified. Users and groups are specified, delimited by commas. Groups are designated by a @ prefix.', max_length=120, verbose_name='Allow List')),
                ('afp_deny', models.CharField(blank=True, help_text='The deny option specifies users and groups who are not allowed access to the share. It follows the same format as the allow option.', max_length=120, verbose_name='Deny List')),
                ('afp_ro', models.CharField(blank=True, help_text='Allows certain users and groups to have read-only access to a share. This follows the allow option format.', max_length=120, verbose_name='Read-only Access')),
                ('afp_rw', models.CharField(blank=True, help_text='Allows certain users and groups to have read/write access to a share. This follows the allow option format.', max_length=120, verbose_name='Read-write Access')),
                ('afp_timemachine', models.BooleanField(default=False, help_text='Check this to enable Time Machine backups on this share.', verbose_name='Time Machine')),
                ('afp_nodev', models.BooleanField(default=False, help_text='Always use 0 for device number, helps when the device number is not constant across a reboot, cluster, ...', verbose_name='Zero Device Numbers')),
                ('afp_nostat', models.BooleanField(default=False, help_text="Don't stat volume path when enumerating volumes list, useful for automounting or volumes created by a preexec script.", verbose_name='No Stat')),
                ('afp_upriv', models.BooleanField(default=True, help_text='Use AFP3 unix privileges.', verbose_name='AFP3 Unix Privs')),
                ('afp_fperm', models.CharField(default='644', max_length=3, verbose_name='Default file permission')),
                ('afp_dperm', models.CharField(default='755', max_length=3, verbose_name='Default directory permission')),
                ('afp_umask', models.CharField(blank=True, default='000', max_length=3, verbose_name='Default umask')),
                ('afp_hostsallow', models.CharField(blank=True, help_text='Allow only listed hosts and/or networks access to this volume', max_length=120, verbose_name='Hosts Allow')),
                ('afp_hostsdeny', models.CharField(blank=True, help_text='Deny listed hosts and/or networks access to this volume', max_length=120, verbose_name='Hosts Deny')),
                ('afp_auxparams', models.TextField(blank=True, help_text='These parameters are added to the [Volume] section of afp.conf. Add each different parameter on a newline', max_length=255, verbose_name='Auxiliary Parameters')),
            ],
            options={
                'ordering': ['afp_name'],
                'verbose_name': 'Apple (AFP) Share',
                'verbose_name_plural': 'Apple (AFP) Shares',
            },
        ),
        migrations.CreateModel(
            name='CIFS_Share',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('cifs_path', freenasUI.freeadmin.models.fields.PathField(blank=True, max_length=255, null=True, verbose_name='Path')),
                ('cifs_home', models.BooleanField(default=False, verbose_name='Use as home share')),
                ('cifs_name', models.CharField(max_length=120, verbose_name='Name')),
                ('cifs_comment', models.CharField(blank=True, max_length=120, verbose_name='Comment')),
                ('cifs_default_permissions', models.BooleanField(default=True, help_text='Recursively set sane default windows permissions on share', verbose_name='Apply Default Permissions')),
                ('cifs_ro', models.BooleanField(default=False, verbose_name='Export Read Only')),
                ('cifs_browsable', models.BooleanField(default=True, verbose_name='Browsable to Network Clients')),
                ('cifs_recyclebin', models.BooleanField(default=False, verbose_name='Export Recycle Bin')),
                ('cifs_showhiddenfiles', models.BooleanField(default=False, verbose_name='Show Hidden Files')),
                ('cifs_guestok', models.BooleanField(default=False, help_text='If true then no password is required to connect to the share. Privileges will be those of the guest account.', verbose_name='Allow Guest Access')),
                ('cifs_guestonly', models.BooleanField(default=False, help_text='If true then only guest connections to the share are permitted. This parameter will have no effect if Allow Guest Access is not set for the share.', verbose_name='Only Allow Guest Access')),
                ('cifs_hostsallow', models.TextField(blank=True, help_text='This option is a comma, space, or tab delimited set of hosts which are permitted to access this share. You can specify the hosts by name or IP number. Leave this field empty to use default settings.', verbose_name='Hosts Allow')),
                ('cifs_hostsdeny', models.TextField(blank=True, help_text='This option is a comma, space, or tab delimited set of host which are NOT permitted to access this share. Where the lists conflict, the allow list takes precedence. In the event that it is necessary to deny all by default, use the keyword ALL (or the netmask 0.0.0.0/0) and then explicitly specify to the hosts allow parameter those hosts that should be permitted access. Leave this field empty to use default settings.', verbose_name='Hosts Deny')),
                ('cifs_vfsobjects', freenasUI.freeadmin.models.fields.MultiSelectField(blank=True, choices=choices.CIFS_VFS_OBJECTS(), default='streams_xattr,aio_pthread', max_length=255, verbose_name='VFS Objects')),
                ('cifs_auxsmbconf', models.TextField(blank=True, help_text='These parameters are added to [Share] section of smb.conf', max_length=120, verbose_name='Auxiliary Parameters')),
                ('cifs_storage_task', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='storage.Task', verbose_name='Periodic Snapshot Task')),
            ],
            options={
                'ordering': ['cifs_name'],
                'verbose_name': 'Windows (SMB) Share',
                'verbose_name_plural': 'Windows (SMB) Shares',
            },
        ),
        migrations.CreateModel(
            name='NFS_Share',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('nfs_comment', models.CharField(blank=True, max_length=120, verbose_name='Comment')),
                ('nfs_network', models.TextField(blank=True, help_text='Networks that are authorized to access the NFS share. Specify network numbers of the form 1.2.3.4/xx where xx is the number of bits of netmask.', verbose_name='Authorized networks')),
                ('nfs_hosts', models.TextField(blank=True, help_text='IP addresses or hostnames that are authorized to access the NFS share.', verbose_name='Authorized IP addresses or hosts')),
                ('nfs_alldirs', models.BooleanField(default=False, help_text='Allow mounting of any subdirectory under this mount point ifselected. Otherwise, only the top level directory can be mounted.', verbose_name='All Directories')),
                ('nfs_ro', models.BooleanField(default=False, help_text='Export the share read only. Writes are not permitted.', verbose_name='Read Only')),
                ('nfs_quiet', models.BooleanField(default=False, help_text='Inhibit syslog warnings if there are problems with exporting this share.', verbose_name='Quiet')),
                ('nfs_maproot_user', freenasUI.freeadmin.models.fields.UserField(blank=True, default='', help_text='The credentials of the specified user is used for remote access by root.', max_length=120, null=True, verbose_name='Maproot User')),
                ('nfs_maproot_group', freenasUI.freeadmin.models.fields.GroupField(blank=True, default='', help_text='The credentials of the specified group is used for remote access by root.', max_length=120, null=True, verbose_name='Maproot Group')),
                ('nfs_mapall_user', freenasUI.freeadmin.models.fields.UserField(blank=True, default='', help_text='The credentials of the specified user is used for remote access by all users.', max_length=120, null=True, verbose_name='Mapall User')),
                ('nfs_mapall_group', freenasUI.freeadmin.models.fields.GroupField(blank=True, default='', help_text='The credentials of the specified group is used for remote access by all users.', max_length=120, null=True, verbose_name='Mapall Group')),
                ('nfs_security', freenasUI.freeadmin.models.fields.MultiSelectField(blank=True, choices=[('sys', 'sys'), ('krb5', 'krb5'), ('krb5i', 'krb5i'), ('krb5p', 'krb5p')], max_length=200, verbose_name='Security')),
            ],
            options={
                'verbose_name': 'Unix (NFS) Share',
                'verbose_name_plural': 'Unix (NFS) Shares',
            },
        ),
        migrations.CreateModel(
            name='NFS_Share_Path',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('path', freenasUI.freeadmin.models.fields.PathField(max_length=255, verbose_name='Path')),
                ('share', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='paths', to='sharing.NFS_Share')),
            ],
            options={
                'ordering': ['path'],
                'verbose_name': 'Path',
                'verbose_name_plural': 'Paths',
            },
        ),
        migrations.CreateModel(
            name='WebDAV_Share',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('webdav_name', models.CharField(help_text="This will be used to access your WebDAV share.<br />For example http(s)://ip-of-freenas-machine:webdav_port/'Share Name'", max_length=120, verbose_name='Share Name')),
                ('webdav_comment', models.CharField(blank=True, max_length=120, verbose_name='Comment')),
                ('webdav_path', freenasUI.freeadmin.models.fields.PathField(max_length=255, verbose_name='Path')),
                ('webdav_ro', models.BooleanField(default=False, help_text='Export the share read only. Writes are not permitted.', verbose_name='Read Only')),
                ('webdav_perm', models.BooleanField(default=True, help_text="Changes the user & group of the shared folder to 'webdav:webdav' recursively (including all subdirectories)<br />If disabled, you will need to manually<br />add the 'webdav' user & group to the share.", verbose_name='Change User & Group Ownership')),
            ],
            options={
                'ordering': ['webdav_name'],
                'verbose_name': 'WebDAV Share',
                'verbose_name_plural': 'WebDAV Shares',
            },
        ),
    ]
