# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2017-11-10 15:27
from __future__ import unicode_literals

from django.db import migrations, models


def normalize_tftp_umask(apps, schema_editor):
    TFTP = apps.get_model('services', 'tftp')
    for row in TFTP.objects.all():
        row.tftp_umask = row.tftp_umask.lstrip("0").zfill(3)
        row.save()


class Migration(migrations.Migration):

    dependencies = [
        ('services', '0017_ftp_set_unlimited_length_for_ftp_options'),
    ]

    operations = [
        migrations.RunPython(
            normalize_tftp_umask,
        ),
    ]
