# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2017-09-17 22:32
from __future__ import unicode_literals
import argparse
import re
import shlex

from django.db import migrations, models


def split_ipserver_into_checkip_server_path(apps, schema_editor):
    DynamicDNS = apps.get_model('services', 'dynamicdns')
    for row in DynamicDNS.objects.all():
        host_path = re.split("\s+", row.ddns_ipserver)
        if len(host_path) > 1:
            row.ddns_checkip_server = host_path[0]
            row.ddns_checkip_path = host_path[1]
            row.save()


def migrate_unsupported_providers(apps, schema_editor):
    DynamicDNS = apps.get_model('services', 'dynamicdns')
    for row in DynamicDNS.objects.all():
        if row.ddns_provider == "dyndns@dyndns.org":
            row.ddns_provider = "default@dyndns.org"
            row.save()

        if row.ddns_provider == "default@he.net":
            row.ddns_provider = "ipv6tb@he.net"
            row.save()

        if row.ddns_provider == "default@dy.fi":
            row.ddns_provider = "custom"
            row.ddns_checkip_server = "checkip.dy.fi"
            row.ddns_checkip_path = "/"
            row.ddns_custom_ddns_server = "www.dy.fi"
            row.ddns_custom_ddns_path = "/nic/update?hostname="
            row.save()

        if row.ddns_provider == "default@joker.com":
            row.ddns_provider = "custom"
            row.ddns_checkip_server = "svc.joker.com"
            row.ddns_checkip_path = "/nic/checkip"
            row.ddns_custom_ddns_server = "svc.joker.com"
            row.ddns_custom_ddns_path = "/nic/update?hostname="
            row.save()

        if row.ddns_provider == "default@majimoto.net":
            row.ddns_provider = "custom"
            row.save()

        if row.ddns_provider == "default@two-dns.de":
            row.ddns_provider = "custom"
            row.ddns_checkip_server = "checkip.two-dns.de"
            row.ddns_checkip_path = "/"
            row.ddns_custom_ddns_server = "update.twodns.de"
            row.ddns_custom_ddns_path = "/update?hostname="
            row.save()

        parser = argparse.ArgumentParser()
        parser.add_argument("--dyndns_server_name")
        parser.add_argument("--dyndns_server_url")
        args, unknown = parser.parse_known_args(shlex.split(row.ddns_options))
        if args.dyndns_server_name:
            row.ddns_provider = "custom"
            row.ddns_custom_ddns_server = args.dyndns_server_name
            row.ddns_custom_ddns_path = "/nic/update?hostname="
            if args.dyndns_server_url:
                row.ddns_custom_ddns_path = args.dyndns_server_url
            row.save()


def set_period_to_updateperiod(apps, schema_editor):
    DynamicDNS = apps.get_model('services', 'dynamicdns')
    for row in DynamicDNS.objects.all():
        try:
            row.ddns_period = int(row.ddns_updateperiod)
        except ValueError:
            pass
        row.save()


class Migration(migrations.Migration):

    dependencies = [
        ('services', '0015_nuke_cifs_srv_minmax_protocols'),
    ]

    operations = [
        migrations.AddField(
            model_name='dynamicdns',
            name='ddns_checkip_ssl',
            field=models.BooleanField(default=False, verbose_name='CheckIP Server SSL'),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='dynamicdns',
            name='ddns_checkip_server',
            field=models.CharField(blank=True,
                                   help_text="The client IP is detected by calling 'url' from this 'ip_server_name:port /.'. Leaving this field blank causes the service to use its built in default: checkip.dyndns.org:80 /.",
                                   max_length=150, verbose_name='CheckIP Server'),
        ),
        migrations.AddField(
            model_name='dynamicdns',
            name='ddns_checkip_path',
            field=models.CharField(blank=True,
                                   help_text="The client IP is detected by calling 'url' from this 'ip_server_name:port /.'. Leaving this field blank causes the service to use its built in default: checkip.dyndns.org:80 /.",
                                   max_length=150, verbose_name='CheckIP Path'),
        ),
        migrations.RunPython(
            split_ipserver_into_checkip_server_path,
        ),
        migrations.RemoveField(
            model_name='dynamicdns',
            name='ddns_ipserver',
        ),

        migrations.AddField(
            model_name='dynamicdns',
            name='ddns_ssl',
            field=models.BooleanField(default=False, verbose_name='Use SSL'),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='dynamicdns',
            name='ddns_custom_ddns_server',
            field=models.CharField(blank=True, help_text='Hostname for your custom DDNS provider.', max_length=150,
                                   verbose_name='Custom Server'),
        ),
        migrations.AddField(
            model_name='dynamicdns',
            name='ddns_custom_ddns_path',
            field=models.CharField(blank=True,
                                   help_text="'%h' will be replaced with your hostname and '%i' will be replaced with your IP address",
                                   max_length=150, verbose_name='Custom Path'),
        ),
        migrations.RunPython(
            migrate_unsupported_providers,
        ),

        migrations.AlterField(
            model_name='dynamicdns',
            name='ddns_domain',
            field=models.CharField(blank=True,
                                   help_text='A host name alias. This option can appear multiple times, for each domain that has the same IP. Use a comma to separate multiple alias names.',
                                   max_length=120, verbose_name='Domain name'),
        ),
        migrations.AlterField(
            model_name='dynamicdns',
            name='ddns_username',
            field=models.CharField(blank=True, max_length=120, verbose_name='Username'),
        ),

        migrations.AddField(
            model_name='dynamicdns',
            name='ddns_period',
            field=models.IntegerField(default=300, help_text='Time in seconds. Default is about 1 min.',
                                      verbose_name='Update Period'),
        ),
        migrations.RunPython(
            set_period_to_updateperiod,
        ),
        migrations.RemoveField(
            model_name='dynamicdns',
            name='ddns_updateperiod',
        ),

        migrations.RemoveField(
            model_name='dynamicdns',
            name='ddns_fupdateperiod',
        ),
        migrations.RemoveField(
            model_name='dynamicdns',
            name='ddns_options',
        ),
    ]
