# -*- coding: utf-8 -*-
# Generated by Django 1.10.3 on 2017-05-26 12:58
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models
import freenasUI.freeadmin.models.fields
from freenasUI import choices

def str_to_class(classname):
    return getattr(sys.modules[__name__], classname)

def migrate_to_new_idmap(apps, schema_editor):
    idmap_backends = ['ad', 'autorid', 'fruit', 'ldap', 'nss', 'rfc2307', 'rid', 'tdb', 'script']
    idmap_domain = apps.get_model('directoryservice.idmap_domain')
    idmap_domaintobackend = apps.get_model('directoryservice.idmap_domaintobackend')
    idmap_domain.objects.bulk_create([
        idmap_domain(id=1, idmap_domain_name='DS_TYPE_ACTIVEDIRECTORY'),
        idmap_domain(id=2, idmap_domain_name='DS_TYPE_LDAP'),
        idmap_domain(id=5, idmap_domain_name='DS_TYPE_DEFAULT_DOMAIN'),
    ])
    for backend in idmap_backends:
        IDMAP = apps.get_model(f'directoryservice.idmap_{backend}')
        for o in IDMAP.objects.all():
            if o.idmap_ds_type:
                domain_field = None
                if o.idmap_ds_type == 1:
                    domain_field = 'DS_TYPE_ACTIVEDIRECTORY'
                elif o.idmap_ds_type == 2:
                    domain_field = 'DS_TYPE_LDAP'
                elif o.idmap_ds_type == 5:
                    domain_field = 'DS_TYPE_DEFAULT_DOMAIN'
                if domain_field:
                    if backend == 'ad':
                        o.idmap_ad_domain_id = domain_field
                    elif backend == 'autorid':
                        o.idmap_autorid_domain_id = domain_field
                    elif backend == 'fruit':
                        o.idmap_fruit_domain_id = domain_field
                    elif backend == 'ldap':
                        o.idmap_ldap_domain_id = domain_field
                    elif backend == 'nss':
                        o.idmap_nss_domain_id = domain_field
                    elif backend == 'rfc2307':
                        o.idmap_rfc2307_domain_id = domain_field
                    elif backend == 'rid':
                        o.idmap_rid_domain_id = domain_field
                    elif backend == 'script':
                        o.idmap_script_domain_id = domain_field
                    elif backend == 'tdb':
                        o.idmap_tdb_domain_id = domain_field
                    o.save()

    AD = apps.get_model(f'directoryservice.activedirectory')
    for o in AD.objects.all():
        if o.ad_idmap_backend:
            idmap_domaintobackend.objects.create(idmap_dtb_domain_id='DS_TYPE_ACTIVEDIRECTORY', idmap_dtb_idmap_backend=o.ad_idmap_backend)
    LDAP = apps.get_model(f'directoryservice.ldap')
    for o in LDAP.objects.all():
        if o.ldap_idmap_backend:
            idmap_domaintobackend.objects.create(idmap_dtb_domain_id='DS_TYPE_LDAP', idmap_dtb_idmap_backend=o.ldap_idmap_backend)

    idmap_domaintobackend.objects.create(idmap_dtb_domain_id='DS_TYPE_DEFAULT_DOMAIN', idmap_dtb_idmap_backend='tdb')

class Migration(migrations.Migration):

    dependencies = [
        ('directoryservice', '0010_encrypt_keytabs'),
    ]

    operations = [
        migrations.CreateModel(
            name='idmap_domain',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('idmap_domain_name', models.CharField(
                    max_length=120,
                    unique=True,
                    help_text=(
                        'Short form of domain name as represented by the nETBIOSName '
                        'LDAP entry in an Active Directory domain (commonly indicated as the '
                        '"pre-Windows 2000" domain name). Do not confuse this with the netbios '
                        'host name of the server.'
                    ),
                    verbose_name='pre-Windows 2000 Domain Name'
                )),
                ('idmap_domain_dns_domain_name', models.CharField(
                    max_length=255,
                    unique=True,
                    null=True,
                    blank=True,
                    verbose_name='DNS Domain Name'
                )),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='idmap_domaintobackend',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('idmap_dtb_domain', models.OneToOneField(
                    on_delete=django.db.models.deletion.CASCADE, 
                    to='directoryservice.idmap_domain', 
                    to_field='idmap_domain_name', 
                    null=True, verbose_name='pre-Windows 2000 Domain Name'
                )),
                ('idmap_dtb_idmap_backend', models.CharField(
                    choices=choices.IDMAP_CHOICES,
                    default='rid',
                    help_text='Idmap backend for winbind.',
                    max_length=120,
                    verbose_name='Idmap backend'
                ))
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.DeleteModel(name='idmap_adex'),
        migrations.DeleteModel(name='idmap_hash'),
        migrations.DeleteModel(name='idmap_tdb2'),
        migrations.AddField(
            model_name='idmap_ad',
            name='idmap_ad_domain',
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE, 
                to='directoryservice.idmap_domain', 
                to_field='idmap_domain_name', 
                null=True, verbose_name='pre-Windows 2000 Domain Name'
            ),
        ), 
        migrations.AddField(
            model_name='idmap_autorid',
            name='idmap_autorid_domain',
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE, 
                to='directoryservice.idmap_domain', 
                to_field='idmap_domain_name', 
                null=True, verbose_name='pre-Windows 2000 Domain Name'
            ),
        ), 
        migrations.AddField(
            model_name='idmap_fruit',
            name='idmap_fruit_domain',
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE, 
                to='directoryservice.idmap_domain', 
                to_field='idmap_domain_name', 
                null=True, verbose_name='pre-Windows 2000 Domain Name'
            ),
        ), 
        migrations.AddField(
            model_name='idmap_ldap',
            name='idmap_ldap_domain',
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE, 
                to='directoryservice.idmap_domain', 
                to_field='idmap_domain_name', 
                null=True, verbose_name='pre-Windows 2000 Domain Name'
            ),
        ), 
        migrations.AddField(
            model_name='idmap_nss',
            name='idmap_nss_domain',
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE, 
                to='directoryservice.idmap_domain', 
                to_field='idmap_domain_name', 
                null=True, verbose_name='pre-Windows 2000 Domain Name'
            ),
        ), 
        migrations.AddField(
            model_name='idmap_rfc2307',
            name='idmap_rfc2307_domain',
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE, 
                to='directoryservice.idmap_domain', 
                to_field='idmap_domain_name', 
                null=True, verbose_name='pre-Windows 2000 Domain Name'
            ),
        ), 
        migrations.AddField(
            model_name='idmap_rid',
            name='idmap_rid_domain',
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE, 
                to='directoryservice.idmap_domain', 
                to_field='idmap_domain_name', 
                null=True, verbose_name='pre-Windows 2000 Domain Name'
            ),
        ), 
        migrations.AddField(
            model_name='idmap_script',
            name='idmap_script_domain',
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE, 
                to='directoryservice.idmap_domain', 
                to_field='idmap_domain_name', 
                null=True, verbose_name='pre-Windows 2000 Domain Name'
            ),
        ), 
        migrations.AddField(
            model_name='idmap_tdb',
            name='idmap_tdb_domain',
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE, 
                to='directoryservice.idmap_domain', 
                to_field='idmap_domain_name', 
                null=True, verbose_name='pre-Windows 2000 Domain Name'
            ),
        ), 
        migrations.AddField(
            model_name='idmap_tdb',
            name='idmap_tdb_domain',
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE, 
                to='directoryservice.idmap_domain', 
                to_field='idmap_domain_name', 
                null=True, verbose_name='pre-Windows 2000 Domain Name'
            ),
        ), 
        migrations.RunPython(migrate_to_new_idmap, reverse_code=migrations.RunPython.noop),       
        migrations.RemoveField(model_name='idmap_ad', name='idmap_ds_id'),
        migrations.RemoveField(model_name='idmap_ad', name='idmap_ds_type'),
        migrations.RemoveField(model_name='idmap_autorid', name='idmap_ds_id'),
        migrations.RemoveField(model_name='idmap_autorid', name='idmap_ds_type'),
        migrations.RemoveField(model_name='idmap_fruit', name='idmap_ds_id'),
        migrations.RemoveField(model_name='idmap_fruit', name='idmap_ds_type'),
        migrations.RemoveField(model_name='idmap_ldap', name='idmap_ds_id'),
        migrations.RemoveField(model_name='idmap_ldap', name='idmap_ds_type'),
        migrations.RemoveField(model_name='idmap_nss', name='idmap_ds_id'),
        migrations.RemoveField(model_name='idmap_nss', name='idmap_ds_type'),
        migrations.RemoveField(model_name='idmap_rfc2307', name='idmap_ds_id'),
        migrations.RemoveField(model_name='idmap_rfc2307', name='idmap_ds_type'),
        migrations.RemoveField(model_name='idmap_rid', name='idmap_ds_id'),
        migrations.RemoveField(model_name='idmap_rid', name='idmap_ds_type'),
        migrations.RemoveField(model_name='idmap_script', name='idmap_ds_id'),
        migrations.RemoveField(model_name='idmap_script', name='idmap_ds_type'),
        migrations.RemoveField(model_name='idmap_tdb', name='idmap_ds_id'),
        migrations.RemoveField(model_name='idmap_tdb', name='idmap_ds_type'),
    ]
