# -*- coding: utf-8 -*-
# Generated by Django 1.10.3 on 2017-02-22 12:00
from __future__ import unicode_literals

from django.db import migrations, models

def add_consul_user(apps, schema_editor):
    try:
        group = apps.get_model("account", "bsdGroups").objects.create(
            bsdgrp_builtin=True,
            bsdgrp_gid="469",
            bsdgrp_group="consul"
        )
        group.save()
        user = apps.get_model("account", "bsdUsers").objects.create(
            bsdusr_builtin=True,
            bsdusr_full_name="Consul Daemon",
            bsdusr_group=group,
            bsdusr_home="/var/tmp/consul",
            bsdusr_shell="/usr/sbin/nologin",
            bsdusr_smbhash="*",
            bsdusr_unixhash="*",
            bsdusr_uid="469",
            bsdusr_username="consul"
        )
        user.save()

    except Exception as e:
        print("ERROR: unable to create consul user/group: ", e)

def remove_consul_user(apps, schema_editor):
    try:
        apps.get_model("account", "bsdUsers").objects.get(
            bsdusr_username="consul"
        ).delete()
        apps.get_model("account", "bsdGroups").objects.get(
            bsdgrp_group="consul"
        ).delete()

    except Exception as e:
        print("ERROR: unable to remove consul user/group: ", e)

class Migration(migrations.Migration):

    dependencies = [
        ('account', '0001_initial'),
    ]

    operations = [
        migrations.RunPython(
            add_consul_user,
            reverse_code=remove_consul_user
        )
    ]
